var circle = new CustomShader('circleProfilePicture'); 
var entries:Array<{icon:FlxSprite, label:FlxText, baseScaleX:Float, baseScaleY:Float, labelOffsetX:Int}> = [];
var curSelected:Int = 0;

var slotY:Array<Float>;
var spacing:Int = 200;
var centerX:Int = 0;
var centerY:Int = 300;

var people = [
    {name: "NuggitMuncher", image: "menus/credits/nuggitMuncher", color: FlxColor.YELLOW, labelOffsetX: 20, scale: 1.0, topText: "Creator, Composer and Artist of Six Peice"},
    {name: "Sublime",        image: "menus/credits/Sublime",        color: FlxColor.PINK,  labelOffsetX: 20, scale: 1.0, topText: "Composer of menu music"},
    {name: "TJGhostly",      image: "menus/credits/TJGhostly",      color: FlxColor.PINK,  labelOffsetX: 100, scale: 0.55, topText: "Charter of Six Peice"},
    {name: "Inakuro",        image: "menus/credits/Inakuro",        color: FlxColor.RED,   labelOffsetX: 20, scale: 1.0, topText: "Coded everything :3"}
];

function create() {
    slotY = [ centerY - spacing, centerY, centerY + spacing ];


    nug = new FlxSprite(200, 200);
    nug.frames = Paths.getSparrowAtlas('menus/TitleNuggit');
    nug.animation.addByPrefix('idle', 'idle', 24, true);
    nug.animation.addByPrefix('select', 'select', 24, false);
    nug.animation.play("idle");
    add(nug);
    nug.alpha = .6;
    nug.scale.set(1.5, 1.5);

    
    for (i in 0...people.length) {
        var person = people[i];
        var offset = wrappedOffset(i, curSelected, people.length);
        var startY = getVisualYForOffset(offset);

        var icon = new FlxSprite(centerX, startY).loadGraphic(Paths.image(person.image));
        icon.shader = circle;
        icon.scale.set(person.scale, person.scale);
        icon.updateHitbox();

        var textX = icon.x + Math.ceil(icon.width * icon.scale.x) + person.labelOffsetX;
        var label = new FlxText(textX, startY + icon.height*icon.scale.y/2 - 10, 0, person.name, 24);
        label.setFormat(null, 24, person.color, "left");

        var alpha = alphaForOffset(offset);
        icon.alpha = alpha;
        label.alpha = alpha;

        add(icon);
        add(label);

        entries.push({icon: icon, label: label, baseScaleX: icon.scale.x, baseScaleY: icon.scale.y, labelOffsetX: person.labelOffsetX});
    }

    modTxt = new FlxText(0, 30, 1800, 'Six Piece Credits', 50);
    modTxt.setFormat(Paths.font("onlyFont.ttf"), 50, FlxColor.RED, "left");
    modTxt.antialiasing = true;
    modTxt.screenCenter(FlxAxes.X);
    modTxt.x += 600;
    add(modTxt);
    camera.zoom = 0.8;
}

function wrappedOffset(index:Int, selected:Int, N:Int):Int {
    var raw = (index - selected) % N;
    if (raw < 0) raw += N;
    return raw;
}

function getVisualYForOffset(offset:Int):Float {
    var N = people.length;
    if (offset == 0) return slotY[1];
    if (offset == 1) return slotY[2];
    if (offset == N - 1) return slotY[0];

    return (offset <= Std.int(N / 2)) ? slotY[2] + spacing : slotY[0] - spacing;
}

function alphaForOffset(offset:Int):Float {
    var N = people.length;
    if (offset == 0) return 1.0;
    if (offset == 1 || offset == N - 1) return 0.3;
    return 0.0;
}

function update(elapsed:Float) {
    if (FlxG.keys.justPressed.UP) changeSelection(-1);
    if (FlxG.keys.justPressed.DOWN) changeSelection(1);
    if (controls.BACK)  FlxG.switchState(new MainMenuState());
}


function changeSelection(dir:Int) {
    var N = people.length;
    curSelected = FlxMath.wrap(curSelected + dir, 0, N - 1);

    modTxt.text = people[curSelected].topText;

    for (i in 0...entries.length) {
        var offset = wrappedOffset(i, curSelected, N);
        var targetY = getVisualYForOffset(offset);

        var entry = entries[i];
        var icon = entry.icon;
        var label = entry.label;
        var labelTargetX = centerX + Math.ceil(icon.width * icon.scale.x) + entry.labelOffsetX;

        FlxTween.tween(icon, { y: targetY }, 0.25, { ease: FlxEase.quadOut });
        FlxTween.tween(label, { y: targetY + icon.height*icon.scale.y/2 - 10, x: labelTargetX }, 0.25, { ease: FlxEase.quadOut });

        var targetAlpha = alphaForOffset(offset);
        FlxTween.tween(icon, { alpha: targetAlpha }, 0.18, { ease: FlxEase.quadOut });
        FlxTween.tween(label, { alpha: targetAlpha }, 0.18, { ease: FlxEase.quadOut });

        var scaleMultiplier = (offset == 0) ? 1.05 : 1.0;
        FlxTween.tween(icon.scale, { x: entry.baseScaleX * scaleMultiplier, y: entry.baseScaleY * scaleMultiplier }, 0.18, { ease: FlxEase.quadOut });
    }
}